% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO-download.R
\name{downloadGEO}
\alias{downloadGEO}
\title{Download GEO data}
\usage{
downloadGEO(GEOID, protocol = c("affymetrix", "agilent"), platform, destDir)
}
\arguments{
\item{GEOID}{The ID of the GEO dataset.}

\item{protocol}{The protocol of selected GEO dataset.}

\item{platform}{The platform of selected GEO dataset.}

\item{destDir}{A path to save downloaded data. If the directory does not exist, it will be created.}
}
\value{
A vector of file paths to the downloaded files. The first element is the metadata file.
}
\description{
This function download and process data from GEO for microarray and RNASeq data.
}
\examples{
\donttest{
library(RCPA)
# Affymetrix
downloadPath <- file.path(tempdir(), "GSE59761")
fileList <- RCPA::downloadGEO(GEOID = "GSE59761", protocol = "affymetrix",
                                platform ="GPL16311", destDir = downloadPath)
}
}
