% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_plots.R
\name{plot.drFitModel}
\alias{plot.drFitModel}
\title{Generic plot function for \code{drFitModel} objects.}
\usage{
\method{plot}{drFitModel}(
  x,
  type = c("confidence", "all", "bars", "none", "obs", "average"),
  ec50line = TRUE,
  add = FALSE,
  broken = TRUE,
  bp,
  gridsize = 200,
  log = "x",
  n.xbreaks,
  n.ybreaks,
  x.lim,
  y.lim,
  pch = 1,
  cex.point,
  cex.axis = 1,
  cex.lab = 1.3,
  col = 1,
  lwd = 2,
  lty = 2,
  xlab,
  ylab,
  legend = TRUE,
  legendText,
  legendPos,
  cex.legend = NULL,
  plot = TRUE,
  export = FALSE,
  height = 7,
  width = 9,
  out.dir = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{drFitModel}, created with \code{\link{growth.drFitModel}}.}

\item{type}{(Character) Specify how to plot the data. There are currently 5 options: "average" (averages and fitted curve(s); default), "none" (only the fitted curve(s)), "obs" (only the data points), "all" (all data points and fitted curve(s)), "bars" (averages and fitted curve(s) with model-based standard errors (see Details)), and "confidence" (confidence bands for fitted curve(s)).}

\item{ec50line}{(Logical) Show pointed horizontal and vertical lines at the EC50 values (\code{TRUE}) or not (\code{FALSE}).}

\item{add}{(Logical) If \code{TRUE} then add to already existing plot.}

\item{broken}{(Logical) If TRUE the x axis is broken provided this axis is logarithmic (using functionality in the CRAN package 'plotrix').}

\item{bp}{(Numeric) Specifying the break point below which the dose is zero (the amount of stretching on the dose axis above zero in order to create the visual illusion of a logarithmic scale including 0). The default is the base-10 value corresponding to the rounded value of the minimum of the log10 values of all positive dose values. This argument is only working for logarithmic dose axes.}

\item{gridsize}{(Numeric) Number of points in the grid used for plotting the fitted curves.}

\item{log}{(Character) String which contains '"x"' if the x axis is to be logarithmic, '"y"' if the y axis is to be logarithmic and '"xy"' or '"yx"' if both axes are to be logarithmic. The default is "x". The empty string "" yields the original axes.}

\item{n.xbreaks}{(Numeric) Number of breaks on the x-axis (if not log-transformed). The breaks are generated using \code{pretty}. Thus, the final number of breaks can deviate from the user input.}

\item{n.ybreaks}{(Numeric) Number of breaks on the y-axis (if not log-transformed). The breaks are generated using \code{pretty}. Thus, the final number of breaks can deviate from the user input.}

\item{x.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the x-axis of both growth curve and derivative plots as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{y.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on y-axis of the growth curve plot as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{pch}{(Numeric) Symbol used to plot data points.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{cex.axis}{(Numeric) Font size of axis annotations.}

\item{cex.lab}{(Numeric) Font size of axis titles.}

\item{col}{(Logical or a vector of colors) If \code{TRUE} default colours are used. If \code{FALSE} (default) no colors are used.}

\item{lwd}{(Numeric) Line width.}

\item{lty}{(Numeric) Specify the line type.}

\item{xlab}{(Character) An optional label for the x axis.}

\item{ylab}{(Character) An optional label for the y axis.}

\item{legend}{(Logical) If \code{TRUE} a legend is displayed.}

\item{legendText}{(Character) Specify the legend text (the position of the upper right corner of the legend box).}

\item{legendPos}{(Numeric) Vector of length 2 giving the position of the legend.}

\item{cex.legend}{numeric specifying the legend text size.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}).}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A plot with the dose-response model fit.
}
\description{
Generic plot function for \code{drFitModel} objects.
}
\examples{
conc <- c(0, rev(unlist(lapply(1:18, function(x) 10*(2/3)^x))),10)
response <- c(1/(1+exp(-0.7*(4-conc[-20])))+stats::rnorm(19)/50, 0)

TestRun <- growth.drFitModel(conc, response, drID = "test")

print(summary(TestRun))
plot(TestRun)
}
\references{
Christian Ritz, Florent Baty, Jens C. Streibig, Daniel Gerhard (2015). \emph{Dose-Response Analysis Using R}. PLoS ONE 10(12): e0146021. DOI: 10.1371/journal.pone.0146021
}
