% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_refseq_pq}
\alias{plot_refseq_pq}
\title{Plot the nucleotide proportion of references sequences}
\usage{
plot_refseq_pq(
  physeq,
  hill_scales = NULL,
  first_n = min(Biostrings::width(physeq@refseq)),
  last_n = NULL,
  min_width = first_n
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{hill_scales}{(vector) A vector defining the Hill number wanted. Set to NULL if
you don't want to plot Hill diversity metrics.}

\item{first_n}{(int, default 10) The number of nucleotides to plot the 5' extremity.}

\item{last_n}{(int, default 10) The number of nucleotides to plot the 3' extremity.}

\item{min_width}{(int, default 0) Select only the sequences from physeq@refseq with using a
minimum length threshold. If \code{first_n} is superior to the minimum length of the
references sequences, you must use min_width to filter out the narrower sequences}
}
\value{
A ggplot2 object
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


It is a wrapper of the function \code{plot_refseq_extremity_pq()}. See
?plot_refseq_extremity_pq for more examples.

If \code{hill_scale} is not null, Hill diversity number are used to represent the distribution
of the diversity (equitability) along the sequences.
}
\examples{
plot_refseq_pq(data_fungi)
plot_refseq_pq(data_fungi, hill_scales = c(2), first_n = 300)

}
\author{
Adrien Taudière
}
