% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.codes.R
\name{Pred.data}
\alias{Pred.data}
\title{Predict Time-Series Data from Fitted Spline Models}
\usage{
Pred.data(Fitted_models, metadata, Group, time_step, Sample_Time)
}
\arguments{
\item{Fitted_models}{A list object generated by \code{\link[MicrobTiSDA]{Reg.SPLR}}.}

\item{metadata}{A data frame. Containing information about all samples, including at least the grouping of all samples as well as
individual information (\code{Group} and \code{ID}), the sampling \code{Time} point for each sample, and other relevant information.}

\item{Group}{A character string indicating the column name in \code{metadata} that defines subject information for prediction.}

\item{time_step}{A numeric value specifying the interval between new time points in the prediction sequence.}

\item{Sample_Time}{A character string indicating the column name in \code{metadata} that contains sample time information.}
}
\value{
An object of class \code{PredictedData} which contains the predict microbial feature abundances at the new time points, with rows
labeled by the group and time (formatted as \code{Group_T_Time}) and an additional column \code{Predicted_Time}.
}
\description{
This function generates predicted OTU abundances at new time points using previously fitted spline regression models.
For each subject defined in the fitted models, it extracts the time range from the metadata, creates a new sequence of time points
with a specified interval, and uses the corresponding fitted models to predict values at these new time points.
}
\details{
The function accepts a list of fitted models (typically the output from \code{\link[MicrobTiSDA]{Reg.SPLR}}) and sample metadata.
For each subject (as defined by the \code{Group} parameter), it extracts the subset of metadata corresponding to that subject. The minimum and maximum time
values are determined, and a new sequence of time points is generated using the provided \code{time_step}. For each OTU model of the
subject, predictions are obtained via the \code{predict} function applied to the new time points, and the results are compiled into a data
frame with an additional column \code{Predicted_Time} indicating the prediction time. The output is a list of data frames, each corresponding
to a subject, containing the predicted OTU abundances.
}
\examples{
\donttest{
# Example metadata with grouping variables
metadata <- data.frame(
  TimePoint = c(1, 2, 3, 4),
  Sample = c('S1', 'S2', 'S3', 'S4'),
  GroupA = c('A', 'A', 'B', 'B'),
  GroupB = c('X', 'Y', 'X', 'Y')
)

# Example pre-processed data (e.g., transformed abundance data)
Pre_processed_Data <- data.frame(
  Feature1 = rnorm(4),
  Feature2 = rnorm(4)
)

# Create design matrix using grouping variables
design_data <- Design(metadata, Group_var = c('GroupA', 'GroupB'), Pre_processed_Data,
                      Sample_Time = 'TimePoint', Sample_ID = 'Sample')

reg <- Reg.SPLR(design_data,
                  Pre_processed_Data,
                  z_score = 2,
                  unique_values = 5,
                  Knots = NULL,
                  max_Knots = 5)
predictions <- Pred.data(reg,
                        metadata,
                        Group = "GroupA",
                        time_step = 1,
                        Sample_Time = "TimePoint")
}
}
\author{
Shijia Li
}
