% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hc_forms.R
\name{get_hc_forms}
\alias{get_hc_forms}
\title{Get Pharmaceutical Forms from Health Canada Drug Product Database}
\source{
Health Canada Drug Product Database (DPD) API:
\url{https://health-products.canada.ca/api/documentation/dpd-documentation-en.html}
}
\usage{
get_hc_forms()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{drug_code}: Unique code identifying the drug product.
  \item \code{pharm_form_code}: Code representing the pharmaceutical form.
  \item \code{pharm_form_desc}: Description of the pharmaceutical form (e.g., Tablet, Capsule, Solution).
}
}
\description{
Retrieves information on all pharmaceutical dosage forms listed in the
Health Canada Drug Product Database (DPD) using the
RESTful API endpoint \code{/drug/form}.

This includes details such as the drug code, form code, and the
pharmaceutical form name (e.g., tablet, capsule, solution).
}
\details{
This function sends a GET request to the Health Canada Drug Product Database API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from Health Canada
  get_hc_forms()
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
