% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR_response.R
\name{llmr_response}
\alias{llmr_response}
\alias{finish_reason}
\alias{tokens}
\alias{is_truncated}
\alias{as.character.llmr_response}
\alias{print.llmr_response}
\title{LLMR Response Object}
\usage{
finish_reason(x)

tokens(x)

is_truncated(x)

\method{as.character}{llmr_response}(x, ...)

\method{print}{llmr_response}(x, ...)
}
\arguments{
\item{x}{An \code{llmr_response} object.}

\item{...}{Ignored.}
}
\value{
A length-1 character vector or \code{NA_character_}.

A list \code{list(sent, rec, total, reasoning)}. Missing values are \code{NA}.

\code{TRUE} if truncated, otherwise \code{FALSE}.
}
\description{
A lightweight S3 container for \strong{generative} model calls. It standardizes
finish reasons and token usage across providers and keeps the raw response
for advanced users.

Returns the standardized finish reason for an \code{llmr_response}.

Returns a list with token counts for an \code{llmr_response}.

Convenience check for truncation due to token limits.
}
\details{
\subsection{Fields}{
\itemize{
\item \code{text}: character scalar. Assistant reply.
\item \code{provider}: character. Provider id (e.g., \code{"openai"}, \code{"gemini"}).
\item \code{model}: character. Model id.
\item \code{finish_reason}: one of \code{"stop"}, \code{"length"}, \code{"filter"}, \code{"tool"}, \code{"other"}.
\item \code{usage}: list with integers \code{sent}, \code{rec}, \code{total}, \code{reasoning} (if available).
\item \code{response_id}: provider’s response identifier if present.
\item \code{duration_s}: numeric seconds from request to parse.
\item \code{raw}: parsed provider JSON (list).
\item \code{raw_json}: raw JSON string.
}
}

\subsection{Printing}{

\code{print()} shows the text, then a compact status line with model, finish reason,
token counts, and a terse hint if truncated or filtered.
}

\subsection{Coercion}{

\code{as.character()} extracts \code{text} so the object remains drop-in for code that
expects a character return.
}
}
\section{See also}{

\code{\link[=call_llm]{call_llm()}}, \code{\link[=call_llm_robust]{call_llm_robust()}}, \code{\link[=llm_chat_session]{llm_chat_session()}},
\code{\link[=llm_config]{llm_config()}}, \code{\link[=llm_mutate]{llm_mutate()}}, \code{\link[=llm_fn]{llm_fn()}}
}

\examples{
# Minimal fabricated example (no network):
r <- structure(
  list(
    text = "Hello!",
    provider = "openai",
    model = "demo",
    finish_reason = "stop",
    usage = list(sent = 12L, rec = 5L, total = 17L, reasoning = NA_integer_),
    response_id = "resp_123",
    duration_s = 0.012,
    raw = list(choices = list(list(message = list(content = "Hello!")))),
    raw_json = "{}"
  ),
  class = "llmr_response"
)
as.character(r)
finish_reason(r)
tokens(r)
print(r)
\dontrun{
fr <- finish_reason(r)
}
\dontrun{
u <- tokens(r)
u$total
}
\dontrun{
if (is_truncated(r)) message("Increase max_tokens")
}
}
