\name{sequencePlot}
\alias{sequencePlot}
\title{
Plot the path of a muscle fiber generated using good.fibes}
\description{
Plots images in sequence showing the image stack and the location of the muscle fiber path at each step in the fiber tracking algorithm in good.fibes
}
\usage{
sequencePlot(fib.track, images, threshold = 0.1, sleep.time = 0.5)
}
\arguments{
  \item{fib.track}{
A set of $fiber.points from a fiber list, generated by good.fibes
}
  \item{images}{
A character vector of image stack file names. Generated with list.files
}
  \item{threshold}{
A cutoff values under which voxels are set to black
}
  \item{sleep.time}{
Time in seconds between images, sets speed for plotting sequence
}
}
\value{
Returns a sequence of plots
}

\references{
Arbour, J. In Prep. GoodFibes: an R package for the detection of muscle fibers from diceCT scans.
}
\author{
J. Arbour
}
\seealso{
\code{\link{thresholdPlot}}
}
\examples{
\donttest{

olddir<-getwd()

#### this downloads the ant dataset image stack
#### if you have it already downloaded you can navigate to that folder
setwd(tempdir())
download.file(url=
"https://github.com/jessica-arbour/Ant-Muscle-Image-Stack/raw/main/Ant_data.zip",
destfile="antdata.zip")

unzip("antdata.zip")
setwd(paste0(getwd(),"/Ant data"))
####

images<-list.files(pattern=".png")

data(ant.raw)

sequencePlot(ant.raw[[2]]$fiber.points, images, 0 ,0.2)



setwd(olddir)
}

}