% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCubeOfCovDis.R
\name{createCubeOfCovDis}
\alias{createCubeOfCovDis}
\title{compute a cube of covariance and a cube of distance
between the items (rows) of a brick of measurements 
(when all blocks
have the same number of variables).}
\usage{
createCubeOfCovDis(brickOfData, scale = TRUE, center = TRUE, ev.scale = TRUE)
}
\arguments{
\item{brickOfData}{a 
\eqn{I} items by \eqn{J} quantitative variables
 by \eqn{K} assessors.}

\item{scale}{(Default: \code{TRUE}), when \code{TRUE}
scale to norm 1 each column for each slice.}

\item{center}{(Default: \code{TRUE}), when \code{TRUE}
centers each column.}

\item{ev.scale}{(Default: \code{TRUE}), when \code{TRUE}
normalizes each slice 
(i.e., each \eqn{I} items by \eqn{J}  matrix) so that its first 
eigenvalue is equal to 1.}
}
\value{
a list with 1) \code{cubeOfCovariance}
a cube of \eqn{K}  \eqn{I} by \eqn{I} covariance matrices;
and 2) \code{cubeOfDistance}
a cube of \eqn{K}  \eqn{I} by \eqn{I} 
(squared) Euclidean distance
  matrices.
}
\description{
\code{createCubeOfCovDis}
compute a cube of covariance and a cube of 
(squared) Euclidean distance
between the items (rows) of a brick of measurements.
The variables describing the items can scaled to norm 1
and centered. The whole matrix 
can  be scaled by its first eigenvalue
(a la DISTATIS). All "slices" of the brick
should have the same number of variables.
For different number of variables per block,
see \code{list2CubeOfCov}.
}
\details{
The input of  \code{createCubeOfCovDis} is a 
\eqn{I} items by \eqn{J} quantitative variables
by \eqn{K} assessors (as obtained, e.g., from a projective
mapping task).

By default  \code{createCubeOfCovDis}
centers and normalizes each column for each slice of the brick
and then normalize each covariance matrix such that
the first eigenvalue of each covariance matrix is equal to 1.
 
A \code{distatis} analysis of the Distance matrices with
the option \code{Distance = TRUE} will give the same results
as the \code{distatis} analysis of the Covariance matrices with
the option \code{Distance = FALSE}.
}
\examples{
\donttest{
# use the data from the BeersProjectiveMapping dataset
data("BeersProjectiveMapping") 
# Create the I*J_k*K brick of data
zeBrickOfData <- projMap2Cube(
                     BeersProjectiveMapping$ProjectiveMapping, 
                     shape = 'flat',  nVars = 2)
# Create the cubes of Covariance and Distance                     
cubes <- createCubeOfCovDis(zeBrickOfData$cubeOfData)
}
}
\seealso{
list2CubeOfCov
}
\author{
Herve Abdi
}
