/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.rosuda.ibase.toolkit.PlotManager;
import org.rosuda.ibase.toolkit.PlotObject;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.pograss.PoGraSSimage;

public class PlotImage
extends PlotObject {
    double x1;
    double y1;
    double x2;
    double y2;
    PoGraSSimage img;

    public PlotImage(PlotManager plotManager) {
        super(plotManager);
    }

    public void setImage(PoGraSSimage poGraSSimage) {
        this.img = poGraSSimage;
    }

    public void setImage(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.img = new PoGraSSimage(byteArrayInputStream);
        }
        catch (IOException iOException) {
            System.err.println("WARNING: cannot create image from bytes: " + iOException);
        }
    }

    public void setImage(String string) {
        try {
            this.img = new PoGraSSimage(string);
        }
        catch (IOException iOException) {
            System.err.println("WARNING: cannot create image from file '" + string + "': " + iOException);
        }
    }

    public void set(int n, int n2, int n3, int n4) {
        this.set(n, n2, n3, n4);
    }

    public void set(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public void draw(PoGraSS poGraSS) {
        if (this.cold != null) {
            this.cold.use(poGraSS);
        }
        poGraSS.drawImage(this.img, this.getXPos(this.x1), this.getYPos(this.y2), this.getXPos(this.x2), this.getYPos(this.y1));
    }

    public String toString() {
        return "PlotImage(" + this.x1 + ":" + this.y1 + "-" + this.x2 + ":" + this.y2 + ",coord=" + this.coordX + "/" + this.coordY + ")";
    }
}

