% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_mb_coxmos.R
\name{cv.mb.coxmos}
\alias{cv.mb.coxmos}
\title{Multiblock COX Cross-Validation Function}
\usage{
cv.mb.coxmos(
  method = c("sb.splsicox", "sb.splsdrcox", "sb.splsdrcox_penalty", "sb.splsdacox",
    "isb.splsicox", "isb.splsdrcox", "isb.splsdrcox_penalty", "isb.splsdacox",
    "mb.splsdrcox", "mb.splsdacox"),
  X,
  Y,
  max.ncomp = 8,
  penalty.list = seq(0.1, 0.9, 0.2),
  vector = NULL,
  MIN_NVAR = 1,
  MAX_NVAR = NULL,
  n.cut_points = 5,
  n_run = 3,
  k_folds = 10,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = TRUE,
  toKeep.zv = NULL,
  remove_variance_at_fold_level = FALSE,
  remove_non_significant_models = FALSE,
  remove_non_significant = FALSE,
  alpha = 0.05,
  w_AIC = 0,
  w_C.Index = 0,
  w_AUC = 1,
  w_I.BRIER = 0,
  MIN_AUC_INCREASE = 0.01,
  EVAL_METHOD = "AUC",
  pred.method = "cenROC",
  pred.attr = "mean",
  MIN_AUC = 0.8,
  MIN_COMP_TO_CHECK = 3,
  max.iter = 200,
  times = NULL,
  max_time_points = 15,
  design = NULL,
  fast_mode = FALSE,
  MIN_EPV = 5,
  return_models = FALSE,
  returnData = FALSE,
  PARALLEL = FALSE,
  n_cores = NULL,
  verbose = FALSE,
  seed = 123
)
}
\arguments{
\item{method}{Cross-validation method to use: "sb.splsicox", "sb.splsdrcox", "sb.splsdrcox_penalty", "sb.splsdacox",
"isb.splsicox", "isb.splsdrcox", "isb.splsdrcox_penalty", "isb.splsdacox", "mb.splsdrcox", or "mb.splsdacox".}

\item{X}{List of numeric matrices or data.frames. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{max.ncomp}{Numeric. Maximum number of PLS components to compute for the cross validation
(default: 8).}

\item{penalty.list}{Numeric vector. Penalty for variable selection for the individual cox
models. Variables with a lower P-Value than 1 - "penalty" in the individual cox analysis will
be keep for the sPLS-ICOX approach (default: seq(0.1,0.9,0.2)) (sb.splsicox, sb.splsdrcox_penalty, isb.splsicox, isb.splsdrcox_penalty).}

\item{vector}{Numeric vector. Used for computing best number of variables. As many values as
components have to be provided. If vector = NULL, an automatic detection is perform (default: NULL) (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{MIN_NVAR}{Numeric. Minimum range size for computing cut points to select the best number of
variables to use (default: 1) (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{MAX_NVAR}{Numeric. Maximum range size for computing cut points to select the best number of
variables to use (default: NULL) (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{n.cut_points}{Numeric. Number of cut points for searching the optimal number of variables.
If only two cut points are selected, minimum and maximum size are used (default: 5) (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{n_run}{Numeric. Number of runs for cross validation (default: 3).}

\item{k_folds}{Numeric. Number of folds for cross validation (default: 10).}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_variance_at_fold_level}{Logical. If remove_variance_at_fold_level = TRUE, (near) zero
variance will be removed at fold level (default: FALSE).}

\item{remove_non_significant_models}{Logical. If remove_non_significant_models = TRUE,
non-significant models are removed before computing the evaluation (default: FALSE).}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{w_AIC}{Numeric. Weight for AIC evaluator (default: 0).}

\item{w_C.Index}{Numeric. Weight for C-Index evaluator (default: 0).}

\item{w_AUC}{Numeric. Weight for AUC evaluator (default: 1).}

\item{w_I.BRIER}{Numeric. Weight for BRIER SCORE evaluator (default: 0).}

\item{MIN_AUC_INCREASE}{Numeric. Minimum improvement between different cross validation models to
continue evaluating higher values (default: 0.01).}

\item{EVAL_METHOD}{Character. The selected metric will be use to compute the best
number of variables (default: "AUC") (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{pred.method}{Character. AUC evaluation algorithm method (default: "cenROC") (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{pred.attr}{Character. Way to evaluate the metric selected (default: "mean").}

\item{MIN_AUC}{Numeric. Minimum AUC desire to reach cross-validation models (default: 0.8).}

\item{MIN_COMP_TO_CHECK}{Numeric. Number of penalties/components to evaluate to check if the AUC
improves (default: 3).}

\item{max.iter}{Numeric. Maximum number of iterations for PLS convergence (default: 200) (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{times}{Numeric vector. Time points where the AUC will be evaluated (default: NULL) (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{max_time_points}{Numeric. Maximum number of time points to use for evaluating the model
(default: 15) (sb.splsdrcox, sb.splsdacox, isb.splsdrcox, isb.splsdacox, mb.splsdrcox, mb.splsdacox).}

\item{design}{Numeric matrix. Matrix of size (number of blocks in X) x (number of blocks in X) with
values between 0 and 1 (default: NULL) (mb.splsdrcox and mb.splsdacox).}

\item{fast_mode}{Logical. If fast_mode = TRUE, for each run, only one fold is evaluated
simultaneously (default: FALSE).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model (default: 5).}

\item{return_models}{Logical. Return all models computed in cross validation (default: FALSE).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{PARALLEL}{Logical. Run the cross validation with multicore option (default: FALSE).}

\item{n_cores}{Numeric. Number of cores to use for parallel processing. This parameter is only
used if \code{PARALLEL} is \code{TRUE}. If \code{NULL}, it will use all available cores minus one. Otherwise,
it will use the minimum between the value specified and the total number of cores - 1. The fewer
cores used, the less RAM memory will be used.(default: NULL).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}

\item{seed}{Number. Seed value for performing runs/folds divisions (default: 123).}
}
\value{
A cross-validation object of the specified multiblock type.
}
\description{
This function provides a unified interface for all multiblock HD-COX cross-validation methods in the package.
}
\examples{
data("X_multiomic")
data("Y_multiomic")
set.seed(123)
X_train <- X_multiomic
X_train$mirna <- X_train$mirna[1:20,1:30]
X_train$proteomic <- X_train$proteomic[1:20,1:30]
Y_train <- Y_multiomic[1:20,]
cv_mb <- cv.mb.coxmos(method = "sb.splsicox", X = X_train, Y = Y_train,
                     max.ncomp = 1, n_run = 1, k_folds = 2)
}
\seealso{
\code{\link{cv.sb.splsicox}} for Single-Block SPLS-ICOX cross-validation,
\code{\link{cv.sb.splsdrcox_penalty}} for Single-Block SPLS-DRCOX with penalty cross-validation,
\code{\link{cv.sb.splsdrcox}} for Single-Block SPLS-DRCOX cross-validation,
\code{\link{cv.sb.splsdacox}} for Single-Block SPLS-DACOX cross-validation,
\code{\link{cv.isb.splsicox}} for Integrated Single-Block SPLS-ICOX cross-validation,
\code{\link{cv.isb.splsdrcox_penalty}} for Integrated Single-Block SPLS-DRCOX with penalty cross-validation,
\code{\link{cv.isb.splsdrcox}} for Integrated Single-Block SPLS-DRCOX cross-validation,
\code{\link{cv.isb.splsdacox}} for Integrated Single-Block SPLS-DACOX cross-validation,
\code{\link{cv.mb.splsdrcox}} for Multi-Block SPLS-DRCOX cross-validation,
\code{\link{cv.mb.splsdacox}} for Multi-Block SPLS-DACOX cross-validation
}
