/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaButtonBorder;
import ch.randelshofer.quaqua.QuaquaIconFactory;
import ch.randelshofer.quaqua.QuaquaPlacardButtonBorder;
import ch.randelshofer.quaqua.QuaquaSquareButtonBorder;
import ch.randelshofer.quaqua.border.BackgroundBorderUIResource;
import ch.randelshofer.quaqua.border.ButtonStateBorder;
import ch.randelshofer.quaqua.border.CachedImageBevelBorder;
import ch.randelshofer.quaqua.border.FocusedBorder;
import ch.randelshofer.quaqua.border.ImageBevelBorder;
import ch.randelshofer.quaqua.border.QuaquaNativeButtonStateBorder;
import ch.randelshofer.quaqua.border.QuaquaNativeImageBevelBorder;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class QuaquaBorderFactory {
    private QuaquaBorderFactory() {
    }

    public static Border create(Image img, Insets borderInsets) {
        return QuaquaBorderFactory.create(img, borderInsets, borderInsets);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets) {
        return QuaquaBorderFactory.create(img, imageInsets, borderInsets, true, null, true);
    }

    public static Border create(Image img, Insets borderInsets, boolean fillContentArea, boolean isCaching) {
        return QuaquaBorderFactory.create(img, borderInsets, borderInsets, fillContentArea, null, isCaching);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea) {
        return QuaquaBorderFactory.create(img, imageInsets, borderInsets, fillContentArea, null, true);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea, Color fillColor, boolean isCaching) {
        if (isCaching) {
            return new CachedImageBevelBorder.UIResource(img, imageInsets, borderInsets, fillContentArea);
        }
        return new ImageBevelBorder.UIResource(img, imageInsets, borderInsets, fillContentArea, fillColor);
    }

    public static Border createNativeImageBevelBorder(OSXAquaPainter.Widget widget, Insets painterInsets, Insets imageBevel, Insets borderInsets, boolean fillContentArea) {
        return new QuaquaNativeImageBevelBorder.UIResource(widget, painterInsets, imageBevel, borderInsets, fillContentArea);
    }

    public static Border createSquareButtonBorder() {
        return new QuaquaSquareButtonBorder();
    }

    public static Border createPlacardButtonBorder() {
        return new QuaquaPlacardButtonBorder();
    }

    public static Border create(String location, Insets borderInsets, boolean fill) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), borderInsets, borderInsets, fill, null, false);
    }

    public static Border create(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, null, false);
    }

    public static Border create(String location, Insets imageInsets, Insets borderInsets, boolean fill, Color fillColor) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, fillColor, false);
    }

    public static Border create(String location, Rectangle subimage, Insets imageInsets, Insets borderInsets, boolean fill) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createBufferedImage(location, subimage), imageInsets, borderInsets, fill, null, false);
    }

    public static Border create(String location, Rectangle subimage, Insets imageInsets, Insets borderInsets, boolean fill, Color fillColor) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createBufferedImage(location, subimage), imageInsets, borderInsets, fill, fillColor, false);
    }

    public static Border createBackgroundBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new BackgroundBorderUIResource(QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, null, false));
    }

    public static Border createBackgroundBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill, Color fillColor) {
        return new BackgroundBorderUIResource(QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, fillColor, false));
    }

    public static Border createButtonStateBorder(String location, int tileCount, boolean isTiledHorizontaly, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new ButtonStateBorder.UIResource(QuaquaIconFactory.createImage(location), tileCount, isTiledHorizontaly, imageInsets, borderInsets, fill);
    }

    public static Border createNativeButtonStateBorder(OSXAquaPainter.Widget widget, Insets imageInsets, Insets borderInsets, boolean drawFocusRing) {
        try {
            UIResource border = new QuaquaNativeButtonStateBorder.UIResource(widget, imageInsets, borderInsets);
            if (drawFocusRing) {
                border = new FocusedBorder.UIResource((Border)((Object)border));
            }
            return border;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Object create(String location, Insets insets, int count, boolean horizontal) {
        return QuaquaBorderFactory.create(location, insets, count, horizontal, true, true);
    }

    public static Object create(String location, Insets insets, int count, boolean horizontal, boolean fill, boolean isCaching) {
        BufferedImage[] images = Images.split(QuaquaIconFactory.createImage(location), count, horizontal);
        Border[] borders = new Border[count];
        for (int i = 0; i < count; ++i) {
            borders[i] = QuaquaBorderFactory.create(images[i], insets, insets, fill, null, isCaching);
        }
        return borders;
    }

    public static Border createButtonBorder(String type) {
        return new BackgroundBorderUIResource(new QuaquaButtonBorder("push"));
    }
}

