/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the examples of the Qt Design Studio.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Timeline
import QtQuickUltralite.Extras
import MotorClusterData

Item
{
    id: root
    width: 300
    height: 140
    property bool active: true
    property real visibility: 0

    ColorizedImage {
        id: highBeamTT
        opacity: 1
        anchors.horizontalCenter: parent.horizontalCenter
        source: "images/big/telltales/high-beamsOff.png"
        color: Style.telltallesBlue
    }

    ColorizedImage {
        id: batteryTT
        anchors.top: highBeamTT.bottom
        anchors.topMargin: 10
        anchors.horizontalCenter: parent.horizontalCenter
        source: "images/big/telltales/batteryOff.png"
    }

    ColorizedImage {
        id: engineFailureTT
        opacity: 1
        source: "images/big/telltales/engine-failureOff.png"
        anchors.top: batteryTT.top
        anchors.right: batteryTT.left
        anchors.rightMargin: 32
    }

    ColorizedImage {
        id: engineOilTT
        opacity: 1
        anchors.top: batteryTT.top
        anchors.left: batteryTT.right
        anchors.leftMargin: 32
        source: "images/big/telltales/engine-oilOff.png"
    }

    Timeline {
        id: timeline
        currentFrame: root.visibility*1000
        startFrame: 0
        endFrame: 1000
        enabled: true

        KeyframeGroup {
            target: highBeamTT
            property: "opacity"
            Keyframe {
                frame: 0
                value: 0
            }
        
            Keyframe {
                frame: 195
                value: 1
            }
        }

        KeyframeGroup {
            target: engineFailureTT
            property: "opacity"
            Keyframe {
                frame: 196
                value: 0
            }

            Keyframe {
                frame: 400
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: batteryTT
            property: "opacity"
            Keyframe {
                frame: 399
                value: 0
            }

            Keyframe {
                frame: 601
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: engineOilTT
            property: "opacity"
            Keyframe {
                frame: 610
                value: 0
            }

            Keyframe {
                frame: 800
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }
    }
}

